#pragma once

#include <QObject>
#include <QVector>

#include "variable.h"

// Don't include EasyCAT.h to keep the namespace clean.
class EasyCAT;

class EtherCATSlave : public QObject {
	Q_OBJECT

	private:
		EasyCAT *c;
		QVector<EtherCATInput*> vars;
		char *bufferIn;
		char *bufferOut;
		int sizeInput;
		int sizeOutput;

	public:
		EtherCATSlave ();
		~EtherCATSlave ();
		
	signals:
		// Called by constructor of EtherCATInput.
		void threadSafeRegisterVar (int byteIndex, EtherCATInput *var, QByteArray value);
		
		// Called by subclasses of EtherCATOutput.
		void threadSafeSetValue (int byteIndex, QByteArray value);

	private slots:
		void registerVar (int byteIndex, EtherCATInput *var, QByteArray value);
		void setValue (int byteIndex, QByteArray value);
		
	public slots:
		// Call this repeatedly to read the input and write the output.
		void process ();
		
		// Start a QTimer to repeatedly call process().
		// The method returns immediately.
		void loop (int intervalMs);
};

EtherCATSlave* startEtherCATSlaveInNewThread (int intervalMs);

// Can be called on a slave started with startEtherCATSlaveInNewThread.
// Can be called from any thread.
// The thread where EtherCATSlave runs in will be stopped.
// The EtherCATSlave object will be deleted.
void stopEtherCATSlave (EtherCATSlave *slave);
